

local gTexture = GUI_Texture("firework_flare01","Texture");

local gBlendMode = GUI_Select(
   kBlendNormal,
   "Blend Mode",
   {
      { description="Normal", value=kBlendNormal},
      { description="Additive Alpha", value=kBlendAdditiveAlpha},
      { description="Subtractive", value=kBlendSubtractive},
      { description="Multiplicative", value=kBlendMultiplicative},
      { description="Opaque", value=kBlendOpaque}
   }
);

local gEmitSpeed = GUI_Slider(
   20.00,
   "Particles Per Second",
   1,30);

local gLifetime = GUI_Slider(
   0.60,
   "Lifetime",
   0,20);

local gSystemLife = GUI_Slider(
   0.50,
   "System Life",
   0,20);

local gStartDelay = GUI_Slider(
   0.00,
   "Start Delay",
   0,20);


local gStartScale = GUI_Slider(
   3.00,
   "StartScale",
   0,3);

local gEndScale = GUI_Slider(
   0.10,
   "EndScale",
   0,5);


local gNumParticles = GUI_Slider(
	28.00,
   "NumParticles",
   1,30);

local gPosRange = GUI_Slider(
	0.00,
   "PositionRange",
   0,200);

local gMinYVel = GUI_Slider(
	400.00,
   "Min Start Y Velocity",
   -800,800);

local gMaxYVel = GUI_Slider(
	-300.00,
   "Max Start Y Velocity",
   -800,800);

local gMinXVel = GUI_Slider(
   -276.80,
   "Min Start X Velocity",
   -800,800);

local gMaxXVel = GUI_Slider(
   353.60,
   "Max Start X Velocity",
   -800,800);

local gMinYAnimVel = GUI_Slider(
   0.00,
   "Min Y Gravity",
   -800,800);

local gMaxYAnimVel = GUI_Slider(
   0.00,
   "Max Y Gravity",
   -800,800);

local gMinXAnimVel = GUI_Slider(
   0.00,
   "Min X Gravity",
   -800,800);

local gMaxXAnimVel = GUI_Slider(
   0.00,
   "Max X Gravity",
   -800,800);

local gMinSpinSpeed = GUI_Slider(
   0.00,
   "Min Spin Speed",
   -50,50);

local gMaxSpinSpeed = GUI_Slider(
   0.00,
   "Max Spin Speed",
   -50,50);


local gFadeInTime = GUI_Slider(
   0.50,
   "Fade In Time",
   0,5);

local gFadeOutTime = GUI_Slider(
   0.10,
   "Fade Out Time",
   0,5);




-- SLIDERS



-- ------------------------------------------------------------
-- Initialization phase

-- Define our custom particle properties
pVelocity = Allocate(2) ; -- Allocate a Vec2 velocity member
pAnimVelocity = Allocate(2); -- Allocate animated velocity
pAge = Allocate(1) ; -- Allocate a TReal age member
pSpin = Allocate(1); -- Allocate a TReal spin member
pSpinSpeed = Allocate(1); -- Allocate a TReal spin member

-- dLocus is a data source: An external connection to the particle
-- system. Here we define dLocus for FluidFX, since FluidFX doesn't know
-- to provide the data source; in the game it's defined in 
-- swarm.cpp as a data source, and it gets the mouse position.
if not dLocus then
   dLocus= Vec2(0,0) ; 
end
if not dUp then
   dUp= Vec2(0,-1) ; 
end


-- Set the particle texture
SetTexture(gTexture);

-- Set the blend mode
SetBlendMode(gBlendMode);

-- LAST, we set the total number of particles in the particle
-- system. This doesn't 'create' the particles, but rather
-- allocates a block of 'dead' particles that can be created
-- below.
SetNumParticles(gNumParticles);    

-- ------------------------------------------------------------
-- Action Phase

-- Particle Initialization Rules.
-- 
-- The following rules define how particles are created.
--
-- Any parameter below in initialization or animation rules that 
-- is a scalar, Color(), or Vec2() can alternaly take a function 
-- that returns the same type--and most functions can take any type
-- and will return that same type. The exception is any function
-- that's expecting a scalar in certain parameter positions.

-- Pick one of two positions randomly, and add dLocus.
-- dLocus is defined in swarm.cpp and added to the random
-- range
pPosition:Init( dLocus+fRange(Vec2(-gPosRange,-gPosRange),Vec2(gPosRange,gPosRange)) );

if (gMaxSpinSpeed == 0 and gMinSpinSpeed == 0) then
   pUp:Init(dUp);
else

   pSpin:Init( fRange( 0, 2*3.1415927 ) );
   pSpinSpeed:Init( fRange( gMinSpinSpeed, gMaxSpinSpeed ) );
   pSpin:Anim( pSpin + fTimeScale( pSpinSpeed ) );
   pUp:Anim( f2dRotation( pSpin ) );         
   
end
-- Pick a velocity from a range
pVelocity:Init( fRange(Vec2(gMinXVel, gMinYVel), Vec2(gMaxXVel, gMaxYVel)) );

-- Start color (tint) off as white (natural color of image)
pColor:Init( Color(1,1,1,1) );

-- Start scale out as 0.5
pScale:Init( gStartScale );

-- Start age as 0 milliseconds
pAge:Init(0);

if ((gMinXAnimVel ~= 0 and gMaxXAnimVel ~= 0) or
    (gMinYAnimVel ~= 0 and gMaxYAnimVel ~= 0)) then
   pAnimVelocity:Init( fRange(Vec2(gMinXAnimVel, gMinYAnimVel), Vec2(gMaxXAnimVel, gMaxYAnimVel)));
   pVelocity:Anim(pVelocity + fTimeScale(pAnimVelocity) );
end



-- ------------------------------------------------------------
-- Particle Parameter Animation Functions
--
-- The following rules define how particles animate.
-- Each rule is applied on each frame of animation.

-- Add velocity scaled by time to position

local kPAge = gLifetime * 1000;

if (gEndScale ~= gStartScale) then
   pScale:Anim( fFade( pAge, gStartScale, kPAge, gEndScale) );
end

if (gFadeOutTime ~= 0 or gFadeInTime ~= 0) then
   if (kPAge > 0) then
      pColor:Anim( fFade( 
         pAge,Color(1,1,1,0),
        (gFadeInTime*1000),Color(1,1,1,1),
         kPAge-((gFadeInTime+gFadeOutTime)*1000), Color(1,1,1,1), 
         gFadeOutTime*1000, Color(1,1,1,0) ) );
   else
      pColor:Anim( fFade( 
         pAge,Color(1,1,1,0),
        (gFadeInTime*1000),Color(1,1,1,1) ) );
   end
end

-- Add time to the age
pAge:Anim( pAge+fAge() );

pPosition:Anim( pPosition + (fTimeScale(pVelocity)) );

-- Expire particles over 1500 ms old
if (kPAge > 0) then
   Anim( fExpire( fGreater(pAge,kPAge) ) );
end

-- Create an initial particle (optional)
-- CreateParticles( 1 );


-- A function to run as we're executing
-- seconds - how many seconds have elapsed
local gElapsedTime = 0;
local gActive = true;
function Update(seconds)
   gElapsedTime = gElapsedTime + seconds;
   if (gElapsedTime > gStartDelay) then
      if (gSystemLife > 0 and gElapsedTime > gSystemLife) then
         gActive = false;
      end
      if gActive then
         CreateParticles( seconds * (gEmitSpeed) );
      elseif (gElapsedTime > gSystemLife + gLifetime) then
         Done();
      end
   end
end

